/*-----------------------------
--- iGibU mutator by DR.Doof ---
  ----------------------------*/

class iGibU extends Mutator;

#exec TEXTURE IMPORT NAME=Gib_t1 FILE=Textures\Gib_t1.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Gib_t2 FILE=Textures\Gib_t2.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Gib_t3 FILE=Textures\Gib_t3.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Gib_t4 FILE=Textures\Gib_t4.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=GibCore FILE=Textures\GibCore.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=GibBeam FILE=Textures\GibBeam.bmp MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=GibRing FILE=Textures\GibRing.bmp MIPS=OFF FLAGS=2

function PostBeginPlay()
{
	DeathMatchPlus(Level.Game).DefaultWeapon = Class'iGibUv2.SSRifle';
	Super.PostBeginPlay();
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ((Other.IsA('weapon')) || (Other.IsA('ammo')))
		{
		if ( Other.IsA('ammo') && !Other.IsA('SSCore') )
			{
			ReplaceWith(Other,"iGibUv2.SSCore");
			return false;
			}
		if (Other.IsA('weapon') && !Other.IsA('SSRifle') && !Other.IsA('Translocator'))
			{
			return false;
			}
		}
	return true;
}

function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('SSRifle') )
		{
		SSRifle(Other).MultiSkins[1]=Texture'Gib_t2';
		SSRifle(Other).MultiSkins[2]=Texture'Gib_t3';
		SSRifle(Other).MultiSkins[3]=Texture'Gib_t4';
		SSRifle(Other).MultiSkins[0]=Texture'Gib_t1';
		}
	if ( Other.IsA('SSCore') )
		{
		SSCore(Other).MultiSkins[1]=Texture'GibCore';
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

defaultproperties
{
}

